/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MidPlane.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT Midplane(ITopology *pfirstGeometry, ITopology *psecondGeometry, CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch, long color, IWorkplane **retDispatch)
{
	/*
		creates the workplane between the selected faces and 
		return the workplane
	*/

	START_METHOD("Midplane")

	HRESULT status = CONV_SUCCESS;

	VARIANT_BOOL blnFirstGeometry;
	VARIANT_BOOL blnSecondGeometry;

	CHECK_VAR_STATUS(pfirstGeometry)

	IObject *object1 = CAST(IObject, pfirstGeometry);
	status = object1->IsA(GetBSTR("Geometric"),&blnFirstGeometry);
	CHECK_RETURN_STATUS(status)

	// check for second geometry
	CHECK_VAR_STATUS(psecondGeometry)

	IObject *object2 = CAST(IObject, psecondGeometry);
	status = object2->IsA(GetBSTR("Geometric"),&blnSecondGeometry);
	CHECK_RETURN_STATUS(status)

	IWorkplane *pMidPlane= NULL;

	if(blnFirstGeometry && blnSecondGeometry) {

		IGraphicDocument *activeGraphicDoc = NULL;
		IPartDocument *activePart = NULL;
		IWorkplane *activeWorkplane = NULL;
		ISketch *activeSketch = NULL;

		status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
		CHECK_RETURN_STATUS(status)

		IDesign *design= NULL;
		status = activePart->GetDesign(&design);

		IGeometric *geometricFirst= CAST(IGeometric, pfirstGeometry);

		IGeometry *pGeom0 = NULL;

		// get the first topology geometry

		status = geometricFirst->GetGeometry(&pGeom0);
		CHECK_RETURN_STATUS(status)

		IGeometric *geometricSecond= CAST(IGeometric, psecondGeometry);

		IGeometry *pGeom1 = NULL;

		// get the first topology geometry

		status = geometricSecond->GetGeometry(&pGeom1);
		CHECK_RETURN_STATUS(status)

		//	Create a MidPlane
		IMidPlane *pMid = NULL;
		status = (GetCLASS(MidPlane))->CreateMidPlane(CAST(IPlane,pGeom0),CAST(IPlane,pGeom1),TRUE,&pMid);

		CHECK_RETURN_STATUS(status)

		status = design->CreateWorkplane(CAST(IPlane,pMid), workplaneName.AllocSysString(),&pMidPlane);
		CHECK_RETURN_STATUS(status)	

		// Create a sketch with the given sketch name

		if(!bNoSketch)
		{
			ISketch *pMidplanesSketch = NULL;
			status = pMidPlane->CreateSketch(sketchName.AllocSysString(), &pMidplanesSketch);

			CHECK_RETURN_STATUS(status)

			status = activeGraphicDoc->SetActiveSketch(pMidplanesSketch);
			CHECK_RETURN_STATUS(status)

			// Set the color for the sketch
			if(color<0 || color > 11)
				color = 4;

			IColor *pNewColor= NULL;
			status = (GetCLASS(Color))->CreateColor(1, color * 30, 0.35, 1,&pNewColor);

			CHECK_RETURN_STATUS(status)

			ISketch *sketch = CAST(ISketch, pMidplanesSketch);

			status = sketch->SetColor(pNewColor);
			CHECK_RETURN_STATUS(status)
		}
	}
	else {
		AfxMessageBox ("Improper Selection of Entities");
		pMidPlane = NULL ;
	}
	*retDispatch = pMidPlane;

	END_METHOD("Midplane")
}
